/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.va.isaac.sync.git;

import org.junit.Assert;
import org.junit.Test;
import gov.va.isaac.sync.git.gitblit.GitBlitUtils;

/**
 * {@link GitBlitUtilsTest}
 *
 * @author <a href="mailto:daniel.armbrust.list@gmail.com">Dan Armbrust</a>
 */
public class GitBlitUtilsTest
{
	@Test
	public void TestURLAdjust() throws Exception
	{
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("https:/URL.DNS:PORT/"));
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("https://URL.DNS:PORT"));
		Assert.assertEquals("http://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("http://URL.DNS:PORT/"));
		Assert.assertEquals("http://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("http://URL.DNS:PORT"));
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     /"));
		Assert.assertEquals("https://DNS                     /git/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     "));
		Assert.assertEquals("https://DNS                     /fred/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     /fred"));
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("https://URL.DNS:PORT"));
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("https://URL.DNS:PORT/"));
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("https://URL.DNS:PORT"));
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("https://URL.DNS:PORT/"));
		Assert.assertEquals("HTtps://URL.DNS:PORT/", GitBlitUtils.adjustBareUrlForGitBlit("HTtps://URL.DNS:PORT/"));
	}
	
	@Test
	public void TestBaseURLParse() throws Exception
	{
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.parseBaseRemoteAddress("https://URL.DNS:PORT"));
		Assert.assertEquals("https://URL.DNS:PORT/", GitBlitUtils.parseBaseRemoteAddress("https://URL.DNS:PORT"));
		Assert.assertEquals("Https://URL.DNS:PORT/", GitBlitUtils.parseBaseRemoteAddress("Https://URL.DNS:PORT"));
	}
	
	
}
